﻿unit uSageboxHelpers;

interface

uses
  uSageboxTypes;

type
  // All are record types, so no Free-ing necessary
  TSbCColor = record
    Colors: TSbColors;
    constructor Create(color: TSbColor; color2: TSbColor); overload;
    constructor Create(color: TSbColor ); overload;
    constructor Create(color: TSbString); overload;
    procedure CColor( color: TSbColor                   ); overload;
    procedure CColor(_color: TSbColor; _color2: TSbColor); overload;
    procedure CColor( color: TSbString                  ); overload;
  end;

  TSbCPoint = record
    X: TSbFloat;
    Y: TSbFloat;
    constructor Create(x: TSbFloat; y: TSbFloat); overload;
    constructor Create(p: TSbPoint ); overload;
    constructor Create(p: TSbPointF); overload;
    constructor Create(s: TSbSize  ); overload;
    constructor Create(s: TSbSizeF ); overload;
    procedure CPoint(X: TSbFloat; Y: TSbFloat);
    class function  OperatorPlus    (_class: TSbCPoint; _input: TSbCPoint): TSbCPoint; static;
    class function  OperatorMinus   (_class: TSbCPoint; _input: TSbCPoint): TSbCPoint; static;
    class function  OperatorDivide  (_class: TSbCPoint; _input: TSbFloat ): TSbCPoint; overload; static;
    class function  OperatorDivide  (_class: TSbCPoint; _input: TSbCPoint): TSbCPoint; overload; static;
    class function  OperatorMultiply(_class: TSbCPoint; _input: TSbCPoint): TSbCPoint; static;
    procedure SelfRotateXY(fAngle: TSbFloat);
    function  ToPointF(): TSbPointF;
    function  ToF     (): TSbPointF;
  end;


  TSbKw = record
    Pointer     : TSbLong;
    Resource    : TSbLong;
    ResourceType: TSbInt;
    constructor Create(pointer: TSbLong);
    function UpdateResources(newKey: TSbKw; r: TSbResourceReturn): TSbKw;
    class function OperatorPlus(_class: TSbKw; _input: TSbKw): TSbKw; static;
    class function Color(color: TSbCColor): TSbKw; static;
    class function fgColor(color: TSbCColor): TSbKw; static;
    class function bgColor(color: TSbCColor): TSbKw; static;
    class function PenColor(color: TSbCColor): TSbKw; static;
    class function PenSize(input: TSbFloat): TSbKw; static;
    class function Angle(input: TSbFloat): TSbKw; static;
    class function PadX(input: TSbInt): TSbKw; static;
    class function PadY(input: TSbInt): TSbKw; static;
    class function Default(input: TSbInt): TSbKw; overload; static;
    class function Default(input: TSbFloat): TSbKw; overload; static;
    class function Default(input: TSbDouble): TSbKw; overload; static;
    class function SetDefault(input: TSbInt): TSbKw; static;
    class function Font(input: TSbString): TSbKw; overload; static;
    class function Font(fontSize: TSbInt): TSbKw; overload; static;
    class function NumbersOnly(bNumbersOnly: TSbBool = True): TSbKw; static;
    class function Range(iMin: TSbInt; iMax: TSbInt): TSbKw; overload; static;
    class function RangeF(fMin: TSbFloat; fMax: TSbFloat): TSbKw; static;
    class function Range(fMin: TSbFloat; fMax: TSbFloat): TSbKw; overload; static;
    class function Range(fMin: TSbDouble; fMax: TSbDouble): TSbKw; overload; static;
    class function Just(justType: TSbString): TSbKw; static;
    class function JustBottom(bJustBottom: TSbBool = True): TSbKw; static;
    class function JustTop(bJustTop: TSbBool = True): TSbKw; static;
    class function JustRight(bJustRight: TSbBool = True): TSbKw; static;
    class function JustCenter(bJustCenter: TSbBool = True): TSbKw; static;
    class function JustLeft(bJustLeft: TSbBool = True): TSbKw; static;
    class function JustTopLeft(bJustTopLeft: TSbBool = True): TSbKw; static;
    class function JustTopRight(bJustTopRight: TSbBool = True): TSbKw; static;
    class function JustTopCenter(bJustTopCenter: TSbBool = True): TSbKw; static;
    class function JustBottomLeft(bJustBottomLeft: TSbBool = True): TSbKw; static;
    class function JustBottomRight(bJustBottomRight: TSbBool = True): TSbKw; static;
    class function JustBottomCenter(bJustBottomCenter: TSbBool = True): TSbKw; static;
    class function Center(bCenter: TSbBool = True): TSbKw; static;
    class function CenterX(bCenterX: TSbBool = True): TSbKw; static;
    class function CenterY(bCenterY: TSbBool = True): TSbKw; static;
    class function TextCenter(bTextCenter: TSbBool = True): TSbKw; static;
    class function TextCenterX(bTextCenterX: TSbBool = True): TSbKw; static;
    class function TextCenterY(bTextCenterY: TSbBool = True): TSbKw; static;
    class function JustCenterX(bJustCenterX: TSbBool = True): TSbKw; static;
    class function JustCenterY(bJustCenterY: TSbBool = True): TSbKw; static;
    class function SetPos(x: TSbInt   ; y: TSbInt   ): TSbKw; overload; static;
    class function SetPos(w: TSbFloat ; h: TSbFloat ): TSbKw; overload; static;
    class function SetPos(w: TSbDouble; h: TSbDouble): TSbKw; overload; static;
    class function SetPos(size: TSbCPoint): TSbKw; overload; static;
    class function Pos(x: TSbInt   ; y: TSbInt   ): TSbKw; overload; static;
    class function Pos(w: TSbFloat ; h: TSbFloat ): TSbKw; overload; static;
    class function Pos(w: TSbDouble; h: TSbDouble): TSbKw; overload; static;
    class function Pos(size: TSbCPoint): TSbKw; overload; static;
    class function SetSize(w: TSbInt   ; h: TSbInt   ): TSbKw; overload; static;
    class function SetSize(w: TSbFloat ; h: TSbFloat ): TSbKw; overload; static;
    class function SetSize(w: TSbDouble; h: TSbDouble): TSbKw; overload; static;
    class function SetSize(size: TSbCPoint): TSbKw; overload; static;
    class function Size(w: TSbInt   ; h: TSbInt   ): TSbKw; overload; static;
    class function Size(w: TSbFloat ; h: TSbFloat ): TSbKw; overload; static;
    class function Size(w: TSbDouble; h: TSbDouble): TSbKw; overload; static;
    class function Size(size: TSbCPoint): TSbKw; overload; static;
    class function UpdateNow(bUpdateNow: TSbBool = True): TSbKw; static;
  end;


implementation
uses
  uSageboxLibrary,
  System.Types,
  System.UITypes;


constructor TSbCColor.Create(color: TSbColor; color2: TSbColor);
begin
  Self.CColor(color, color2);
end;

constructor TSbCColor.Create(color: TSbColor );
begin
  Self.CColor(color);
end;


constructor TSbCColor.Create(color: TSbString);
begin
  Self.CColor(color);
end;


procedure TSbCColor.CColor(color: TSbColor);
begin
  Colors.color1.red   := TColors(color).R;
  Colors.color1.green := TColors(color).G;
  Colors.color1.blue  := TColors(color).B;
  Colors.color1.alpha := TColors(color).A;
  Colors.color2.alpha := -1; // i.e. no second color
end;


procedure TSbCColor.CColor(_color: TSbColor; _color2: TSbColor);
begin
  Colors.color1.red   := TColors(_color).R;
  Colors.color1.green := TColors(_color).G;
  Colors.color1.blue  := TColors(_color).B;
  Colors.color1.alpha := TColors(_color).A;
  Colors.color2.red   := TColors(_color2).R;
  Colors.color2.green := TColors(_color2).G;
  Colors.color2.blue  := TColors(_color2).B;
  Colors.color2.alpha := TColors(_color2).A;
end;


procedure TSbCColor.CColor(color: TSbString);
begin
  _SageVB_ColorFromString(color, Colors.color1, Colors.color2);
end;


constructor TSbCPoint.Create(x: TSbFloat; y: TSbFloat);
begin
  Self.X := x;
  Self.Y := y;
end;


constructor TSbCPoint.Create(p: TSbPoint);
begin
  Self.X := p.X;
  Self.Y := p.X;
end;


constructor TSbCPoint.Create(p: TSbPointF);
begin
  Self.X := p.X;
  Self.Y := p.X;
end;


constructor TSbCPoint.Create(s: TSbSize);
begin
  Self.X := s.cx;
  Self.Y := s.cy;
end;


constructor TSbCPoint.Create(s: TSbSizeF);
begin
  Self.X := s.cx;
  Self.Y := s.cy;
end;


procedure TSbCPoint.CPoint(X: TSbFloat; Y:TSbFloat);
begin
  Self.X := X;
  Self.Y := Y;
end;


class function TSbCPoint.OperatorPlus(_class: TSbCPoint; _input: TSbCPoint): TSbCPoint;
begin
  Result := TSbCPoint.Create(_class.X + _input.X, _class.Y + _input.Y);
end;


class function TSbCPoint.OperatorMinus(_class: TSbCPoint; _input: TSbCPoint): TSbCPoint;
begin
  Result := TSbCPoint.Create(_class.X - _input.X, _class.Y - _input.Y);
end;


class function TSbCPoint.OperatorDivide(_class: TSbCPoint; _input: TSbFloat): TSbCPoint;
begin
  Result := TSbCPoint.Create(_class.X / _input, _class.Y / _input);
end;


class function TSbCPoint.OperatorDivide(_class: TSbCPoint; _input: TSbCPoint): TSbCPoint;
begin
  Result := TSbCPoint.Create(_class.X / _input.X, _class.Y / _input.Y);
end;


class function TSbCPoint.OperatorMultiply(_class: TSbCPoint; _input: TSbCPoint): TSbCPoint;
begin
  Result := TSbCPoint.Create(_class.X * _input.X, _class.Y * _input.Y);
end;


procedure TSbCPoint.SelfRotateXY(fAngle: TSbFloat);
var
  fTemp: TSbFloat;
begin
  fAngle := 3.14159 * fAngle / 180.0;
  fTemp  := Self.X * Cos(fAngle) - Self.Y * Sin(fAngle);
  Self.Y := Self.X * Sin(fAngle) + Self.Y * Cos(fAngle);
  Self.X := fTemp;
end;


function TSbCPoint.ToPointF(): TSbPointF;
begin
  Result.x := Self.X;
  Result.y := Self.Y;
end;


function TSbCPoint.ToF(): TSbPointF;
begin
  Result := ToPointF();
end;


constructor TSbKw.Create(pointer: TSbLong);
begin
  Self.Pointer      := pointer;
  Self.Resource     := 0;
  Self.ResourceType := 0;
end;


function TSbKw.UpdateResources(newKey: TSbKw; r: TSbResourceReturn): TSbKw;
begin
  Self.Pointer      := r.pointer;
  Self.Resource     := r.resource;
  Self.ResourceType := r.&type;
  Result            := newKey;
end;


class function TSbKw.OperatorPlus(_class: TSbKw; _input: TSbKw): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_AddObjects(_class.Pointer, _input.Pointer);
  // ?? _SageVB_kw_EvalObject(Result.Pointer)
end;


class function TSbKw.Color(color: TSbCColor): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericColor(13, color.colors.color1.red, color.colors.color1.green, color.colors.color1.blue);
end;


class function TSbKw.fgColor(color: TSbCColor): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericColor(8, color.colors.color1.red, color.colors.color1.green, color.colors.color1.blue);
end;


class function TSbKw.bgColor(color: TSbCColor): TSbKw;
var
  LColors: TSbColors;
begin
  Result  := TSbKw.Create(0);
  LColors := color.colors;
  Result.Pointer := _SageVB_kw_GenericBiColor(9, LColors);
end;


class function TSbKw.PenColor(color: TSbCColor): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericColor(10, color.colors.color1.red, color.colors.color1.green, color.colors.color1.blue);
end;


class function TSbKw.PenSize(input: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericFloat(4, input);
end;


class function TSbKw.Angle(input: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericFloat(5, input);
end;


class function TSbKw.PadX(input: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericInteger(6, input);
end;


class function TSbKw.PadY(input: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericInteger(7, input);
end;


class function TSbKw.Default(input: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericInteger(11, input);
end;


class function TSbKw.Default(input: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericFloat(17, input);
end;


class function TSbKw.Default(input: TSbDouble): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericFloat(17, input);
end;


class function TSbKw.SetDefault(input: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericInteger(11, input);
end;


class function TSbKw.Font(input: TSbString): TSbKw;
var
  rr: TSbResourceReturn;
begin
  Result := TSbKw.Create(0);
  rr     := _SageVB_kw_GenericString(0, input);
  Result.Pointer      := rr.pointer;
  Result.Resource     := rr.resource;
  Result.ResourceType := rr.&type;
end;


class function TSbKw.Font(fontSize: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericInteger(12, fontSize);
end;


class function TSbKw.NumbersOnly(bNumbersOnly: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericBoolean(14, bNumbersOnly);
end;


class function TSbKw.Range(iMin: TSbInt; iMax: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_RangeInt(iMin, iMax);
end;


class function TSbKw.RangeF(fMin: TSbFloat; fMax: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_RangeFloat(fMin, fMax);
end;


class function TSbKw.Range(fMin: TSbFloat; fMax: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_RangeFloat(fMin,fMax);
end;


class function TSbKw.Range(fMin: TSbDouble; fMax: TSbDouble): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_RangeFloat(fMin, fMax);
end;


class function TSbKw.Just(justType: TSbString): TSbKw;
var
  rr: TSbResourceReturn;
begin
  Result := TSbKw.Create(0);
  rr     := _SageVB_kw_GenericString(15, justType);
  Result.Pointer      := rr.pointer;
  Result.Resource     := rr.resource;
  Result.ResourceType := rr.&type;
end;


class function TSbKw.JustBottom(bJustBottom: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(0, bJustBottom);
end;


class function TSbKw.JustTop(bJustTop: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(1, bJustTop);
end;


class function TSbKw.JustRight(bJustRight: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(2, bJustRight);
end;


class function TSbKw.JustCenter(bJustCenter: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(3, bJustCenter);
end;


class function TSbKw.JustLeft(bJustLeft: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(4, bJustLeft);
end;


class function TSbKw.JustTopLeft(bJustTopLeft: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(5, bJustTopLeft);
end;


class function TSbKw.JustTopRight(bJustTopRight: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(6, bJustTopRight);
end;


class function TSbKw.JustTopCenter(bJustTopCenter: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(7, bJustTopCenter);
end;


class function TSbKw.JustBottomLeft(bJustBottomLeft: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(8, bJustBottomLeft);
end;


class function TSbKw.JustBottomRight(bJustBottomRight: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(9, bJustBottomRight);
end;


class function TSbKw.JustBottomCenter(bJustBottomCenter: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(10, bJustBottomCenter);
end;


class function TSbKw.Center(bCenter: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(11, bCenter);
end;


class function TSbKw.CenterX(bCenterX: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(12, bCenterX);
end;


class function TSbKw.CenterY(bCenterY: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(13, bCenterY);
end;


class function TSbKw.TextCenter(bTextCenter: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(14, bTextCenter);
end;


class function TSbKw.TextCenterX(bTextCenterX: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(15, bTextCenterX);
end;


class function TSbKw.TextCenterY(bTextCenterY: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(16, bTextCenterY);
end;


class function TSbKw.JustCenterX(bJustCenterX: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(15, bJustCenterX);
end;


class function TSbKw.JustCenterY(bJustCenterY: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SetJustType(16, bJustCenterY);
end;


class function TSbKw.SetPos(x: TSbInt; y: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairInt(x, y);
end;


class function TSbKw.SetPos(w: TSbFloat; h: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairFloat(w, h);
end;


class function TSbKw.SetPos(w: TSbDouble; h: TSbDouble): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairFloat(w, h);
end;


class function TSbKw.SetPos(size: TSbCPoint): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairFloat(size.X, size.Y);
end;


class function TSbKw.Pos(x: TSbInt; y: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairInt(x, y);
end;


class function TSbKw.Pos(w: TSbFloat; h: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairFloat(w, h);
end;


class function TSbKw.Pos(w: TSbDouble; h: TSbDouble): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairFloat(w, h);
end;


class function TSbKw.Pos(size: TSbCPoint): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_PosPairFloat(size.X, size.Y);
end;


class function TSbKw.SetSize(w: TSbInt; h: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairInt(w, h);
end;


class function TSbKw.SetSize(w: TSbFloat; h: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairFloat(w, h);
end;


class function TSbKw.SetSize(w: TSbDouble; h: TSbDouble): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairFloat(w, h);
end;


class function TSbKw.SetSize(size: TSbCPoint): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairFloat(size.X, size.Y);
end;


class function TSbKw.Size(w: TSbInt; h: TSbInt): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairInt(w, h);
end;


class function TSbKw.Size(w: TSbFloat; h: TSbFloat): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairFloat(w, h);
end;


class function TSbKw.Size(w: TSbDouble; h: TSbDouble): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairFloat(w, h);
end;


class function TSbKw.Size(size: TSbCPoint): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_SizePairFloat(size.X, size.Y);
end;


class function TSbKw.UpdateNow(bUpdateNow: TSbBool = True): TSbKw;
begin
  Result := TSbKw.Create(0);
  Result.Pointer := _SageVB_kw_GenericBoolean(16,bUpdateNow);
end;

end.
