{******************************************************************************
  FileName............: Test.pas
  Copyright...........: 2025-2025 by M.Majoor
 ------------------------------------------------------------------------------
  Test for using the Sagebox DLL

  The MIT License (MIT)

  Copyright (c) 2025 Marcel Majoor

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.


  Date/Version   Comment
   2025.12.07    - Initial release
 ******************************************************************************}
program Test;

uses
  uSageboxTypes   in '..\uSageboxTypes.pas',
  uSageboxLibrary in '..\uSageboxLibrary.pas',
  uSageboxHelpers in '..\uSageboxHelpers.pas',
  System.SysUtils;


procedure Main();
var
  LWindow     : TSbLong;
  LColors     : TSbColors;
  LPointSTruct: TSbPointStruct;
  LColor1     : TSbRgbStruct;
  LColor2     : TSbRgbStruct;
  LX          : TSbFloat;
  LY          : TSbFloat;
begin
  LWindow   := _SageVB_NewWindow(0, 'NewWindow');

  // Use as much as possible of the DLL functions
  // We do this primarily to check for valid names/parameters and not showcasing actual use
  _SageVB_GetEvent();
  _SageVB_Write('Centered Comic Sans 50', LWindow, TSbKw.OperatorPlus(TSbKw.TextCenter, TSbKw.Font('Comic Sans MS,50')).Pointer);
  // _SageVB_ExitButton('ExitButton');
  _SageVB_Init(0, '.');
  _SageVB_SetIniFilePath('.');

  // _SageVB_NewWindow(LKeyWords, 'Title');
  _SageVB_DevSlider      (     'DevSlider'  , 0, False);
  _SageVB_DevText        (100, 'DevText'    , 0);
  _SageVB_DevInputBox    (     'DevInputBox', 0);
  _SageVB_LogVInfo       ('LogVInfoModule', 'LogVInfoMessage');
  _SageVB_SetLogLevelStr ('Debug');
  _SageVB_DebugWrite     ('DebugWrite', True);
  _SageVB_DisableDefaults();
  // kw Class Functions
  _SageVB_kw_AddObjects    (0, 0);
  _SageVB_kw_FreeResource  (0, 0);
  _SageVB_kw_EvalObject    (0);
  _SageVB_kw_GenericColor  (0, 0, 0, 0);
  _SageVB_kw_GenericBiColor(0, LColors);
  _SageVB_kw_GenericString (0, 'GenericString');
  _SageVB_kw_GenericFloat  (0, 0.0);
  _SageVB_kw_GenericInteger(0, 0);
  _SageVB_kw_GenericBoolean(0, False);
  _SageVB_kw_RangeInt      (0, 0);
  _SageVB_kw_RangeFloat    (0.0, 0.0);
  _SageVB_kw_SizePairInt   (0, 0);
  _SageVB_kw_SizePairFloat (0.0, 0.0);
  _SageVB_kw_PosPairInt    (0, 0);
  _SageVB_kw_PosPairFloat  (0.0, 0.0);
  _SageVB_kw_SetJustType   (0, False);
  // --> Slider Functions
  _SageVB_Slider_GetPos  (0);
  _SageVB_Slider_GetPosf (0);
  _SageVB_Slider_GetPosff(0);
  _SageVB_Slider_Moved   (0);
  // --> Input Box Functions
  _SageVB_InputBox_ReturnPressed(0);
  _SageVB_InputBox_GetInteger   (0);
  _SageVB_InputBox_GetText      (0);
  _SageVB_InputBox_ClearText    (0);
  // --> Window Functions
  _SageVB_Window_DrawCircle_Rgb   (0, 0.0, 0.0, 0.0,                LColors, False,        0);
  _SageVB_Window_DrawEllipse_Rgb  (0, 0.0, 0.0, 0.0, 0.0,           LColors, False,        0);
  _SageVB_Window_DrawRectangle_Rgb(0, 0.0, 0.0, 0.0, 0.0,           LColors, False,        0);
  _SageVB_Window_DrawTriangle_Rgb (0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, LColors, False, False, 0);
  _SageVB_Window_DrawPolygon_Rgb  (0, 0,   LPointStruct,            LColors, False,        0);
  _SageVB_Window_SetPixel_Rgb     (0, 0, 0, 0, 0, 0);
  _SageVB_Window_Cls              (0, 0, 0, 0, 0, 0, 0, False);

  _SageVB_Window_ClsStr           (0, '', False);
  _SageVB_ColorFromString         ('DarkBlue', LColor1, LColor2);
  _SageVB_PointStructTest         (0, LPointStruct);
  _SageVB_Window_GetWindowSize    (0,  LX, LY);
  _SageVB_Window_GetWindowCenter  (0, LX, LY);
  _SageVB_DisplayDefaultPaths     ();
  _SageVB_Window_SetAutoUpdateStr (0, '');
  _SageVB_Window_SetAutoUpdateInt (0, 0);


  _SageVB_ExitButton('ExitButton');
end;


begin
  Main();
end.

